<?php 
	class DashboardModel extends Mysql
	{
		public function __construct()
		{
			parent::__construct();
		}

		public function cantUsuarios(){
			$sql = "SELECT COUNT(*) as total FROM persona WHERE status != 0";
			$request = $this->select($sql);
			$total = $request['total']; 
			return $total;
		}
		public function cantClientes(){
			$sql = "SELECT COUNT(*) as total FROM persona WHERE status != 0 AND rolid = ".RCLIENTES;
			$request = $this->select($sql);
			$total = $request['total']; 
			return $total;
		}
		public function cantProductos(){
			$sql = "SELECT COUNT(*) as total FROM producto WHERE status != 0 ";
			$request = $this->select($sql);
			$total = $request['total']; 
			return $total;
		}
		public function cantPedidos(){
			$rolid = $_SESSION['userData']['idrol'];
			$idUser = $_SESSION['userData']['idpersona'];
			$where = "";
			if($rolid == RCLIENTES ){
				$where = " WHERE personaid = ".$idUser;
			}

			$sql = "SELECT COUNT(*) as total FROM pedido ".$where;
			$request = $this->select($sql);
			$total = $request['total']; 
			return $total;
		}

		public function cantHallazgosAbiertos(){
			$sql = "SELECT COUNT(*) as total FROM hallazgos WHERE id_estado_hallazgo = 3 ";			
			$request = $this->select($sql);
			$total = $request['total']; 
			return $total;			
		}
		
		public function cantHallazgosCerrados(){
			$sql = "SELECT COUNT(*) as total FROM hallazgos WHERE id_estado_hallazgo = 1 ";
			$request = $this->select($sql);
			$total = $request['total']; 
			return $total;			
		}
		
		public function cantHallazgosNulos(){
			$sql = "SELECT COUNT(*) as total FROM hallazgos WHERE id_estado_hallazgo = 2 ";
			$request = $this->select($sql);
			$total = $request['total']; 
			return $total;			
		}

		public function cantHallazgos(){
			$sql = "SELECT COUNT(*) as total FROM hallazgos";
			$request = $this->select($sql);
			$total = $request['total']; 
			return $total;			
		}
		
		public function lastHallazgos(){
			$sql = "SELECT h.id_hallazgo, h.fecha as fecha, h.fecha_cierre as fecha_cierre, CONCAT(v.nombre_empleado,' ',v.apellido_empleado) as nombre_colaborador, h.supervisor_area, h.cargo, t.descripcion as nombre_tipo, f.nombre as nombre_fuente, c.descripcion as lugar, ar.nombre as nombre_area, a.nombre as nombre_ambito, h.descripcion, CASE
        WHEN h.id_estado_hallazgo = 1 THEN 'Cerrado'
        WHEN h.id_estado_hallazgo = 2 THEN 'Nulo'
        WHEN h.id_estado_hallazgo = 3 THEN 'Abierto'
    END as nombre_estado
					FROM hallazgos h, cont_sucursal c, areas ar, ambitos a,  vtaop_empleado v, fuente_no_conformidad f, tipos_hallazgos t
					where h.id_obra = c.id_sucursal AND h.area = ar.id_area AND h.empleado = v.id_empleado AND h.id_tipo_hallazgo = t.id_tipo_hallazgo AND h.id_ambito_hallazgo = a.id_ambito_hallazgo AND h.id_fuente_no_conformidad = f.id_fuente_no_conformidad order by h.id_hallazgo desc LIMIT 10";

			$request = $this->select_all($sql);
			
			return $request;
		}	

		public function lastOrders(){
			$rolid = $_SESSION['userData']['idrol'];
			$idUser = $_SESSION['userData']['idpersona'];
			$where = "";
			if($rolid == RCLIENTES ){
				$where = " WHERE p.personaid = ".$idUser;
			}

			$sql = "SELECT p.idpedido, CONCAT(pr.nombres,' ',pr.apellidos) as nombre, p.monto, p.status 
					FROM pedido p
					INNER JOIN persona pr
					ON p.personaid = pr.idpersona
					$where
					ORDER BY p.idpedido DESC LIMIT 10 ";
			$request = $this->select_all($sql);
			return $request;
		}	
		public function selectPagosMes(int $anio, int $mes){

			$sql = "SELECT p.tipopagoid, tp.tipopago, COUNT(p.tipopagoid) as cantidad, SUM(p.monto) as total 
					FROM pedido p 
					INNER JOIN tipopago tp 
					ON p.tipopagoid = tp.idtipopago 
					WHERE MONTH(p.fecha) = $mes AND YEAR(p.fecha) = $anio GROUP BY tipopagoid";
			$pagos = $this->select_all($sql);
			$meses = Meses();
			$arrData = array('anio' => $anio, 'mes' => $meses[intval($mes-1)], 'tipospago' => $pagos );
			return $arrData;
		}

		
		
	public function selectHallazgosAmbito(string $fecha_ini, string $fecha_fin, string $tipografico){
      
      $sql = "SELECT COUNT(*) as cantidad, a.nombre
          FROM hallazgos h
          INNER JOIN ambitos a 
          ON h.id_ambito_hallazgo = a.id_ambito_hallazgo 
          WHERE fecha >= '$fecha_ini' AND fecha <= '$fecha_fin' GROUP BY h.id_ambito_hallazgo order by cantidad DESC";
          
      $hallazgos = $this->select_all($sql);

			$sql1 = "SELECT COUNT(*) as cant_hallazgos
          FROM hallazgos h          
          WHERE fecha >= '$fecha_ini' AND fecha <= '$fecha_fin'";
          
      $cant_hallazgos = $this->select_all($sql1);

      $fecha_ini = convertirFechaBD_fecha($fecha_ini);
      $fecha_fin = convertirFechaBD_fecha($fecha_fin);
      $arrData = array('cant_hallazgos' => $cant_hallazgos[0], 'fecha_ini' => $fecha_ini, 'fecha_fin' => $fecha_fin, 'hallazgos' => $hallazgos, 'tipografico' => $tipografico);    
      
      return $arrData;
    }	
	

public function selectHallazgosFuente(string $fecha_ini, string $fecha_fin, string $tipografico){
      
      $sql = "SELECT COUNT(*) as cantidad, f.nombre
          FROM hallazgos h
          INNER JOIN fuente_no_conformidad f 
          ON h.id_fuente_no_conformidad = f.id_fuente_no_conformidad 
          WHERE fecha >= '$fecha_ini' AND fecha <= '$fecha_fin' GROUP BY h.id_fuente_no_conformidad order by cantidad DESC";
          
      $hallazgos = $this->select_all($sql);

			$sql1 = "SELECT COUNT(*) as cant_hallazgos
          FROM hallazgos h          
          WHERE fecha >= '$fecha_ini' AND fecha <= '$fecha_fin'";
          
      $cant_hallazgos = $this->select_all($sql1);

      $fecha_ini = convertirFechaBD_fecha($fecha_ini);
      $fecha_fin = convertirFechaBD_fecha($fecha_fin);
      $arrData = array('cant_hallazgos' => $cant_hallazgos[0], 'fecha_ini' => $fecha_ini, 'fecha_fin' => $fecha_fin, 'hallazgos' => $hallazgos, 'tipografico' => $tipografico);    
      
      return $arrData;
    }
	public function selectHallazgosColaborador(string $fecha_ini, string $fecha_fin, string $tipografico){
      
      $sql = "SELECT COUNT(*) as cantidad, e.nombre_empleado, e.apellido_empleado
          FROM hallazgos h
          INNER JOIN vtaop_empleado e 
          ON h.empleado = e.id_empleado 
          WHERE fecha >= '$fecha_ini' AND fecha <= '$fecha_fin' GROUP BY empleado order by cantidad DESC";
          
      $hallazgos = $this->select_all($sql);

			$sql1 = "SELECT COUNT(*) as cant_hallazgos
          FROM hallazgos h          
          WHERE fecha >= '$fecha_ini' AND fecha <= '$fecha_fin'";
          
      $cant_hallazgos = $this->select_all($sql1);

      $fecha_ini = convertirFechaBD_fecha($fecha_ini);
      $fecha_fin = convertirFechaBD_fecha($fecha_fin);
      $arrData = array('cant_hallazgos' => $cant_hallazgos[0], 'fecha_ini' => $fecha_ini, 'fecha_fin' => $fecha_fin, 'hallazgos' => $hallazgos, 'tipografico' => $tipografico);    
      
      return $arrData;
    }

		public function selectHallazgosArea(string $fecha_ini_area, string $fecha_fin_area, string $tipografico_area){			
			$sql = "SELECT COUNT(*) as cantidad, a.nombre
					FROM hallazgos h
					INNER JOIN areas a
					ON h.area = a.id_area
					WHERE fecha >= '$fecha_ini_area' AND fecha <= '$fecha_fin_area' GROUP BY area order by cantidad DESC";
					
			$hallazgos_area = $this->select_all($sql);

			$sql1 = "SELECT COUNT(*) as cant_hallazgos_area
          FROM hallazgos h          
          WHERE fecha >= '$fecha_ini_area' AND fecha <= '$fecha_fin_area'";
          
      $cant_hallazgos_area = $this->select_all($sql1);


			$fecha_ini_area = convertirFechaBD_fecha($fecha_ini_area);
			$fecha_fin_area = convertirFechaBD_fecha($fecha_fin_area);
			$arrData = array('cant_hallazgos_area' => $cant_hallazgos_area[0], 'fecha_ini_area' => $fecha_ini_area, 'fecha_fin_area' => $fecha_fin_area, 'hallazgos_area' => $hallazgos_area, 'tipografico_area' => $tipografico_area);		
			
			return $arrData;
		}
		
		public function selectHallazgosTipo(string $fecha_ini_tipo, string $fecha_fin_tipo, string $tipografico_tipo){			
			$sql = "SELECT COUNT(*) as cantidad, t.descripcion
					FROM hallazgos h
					INNER JOIN tipos_hallazgos t
					ON h.id_tipo_hallazgo = t.id_tipo_hallazgo
					WHERE fecha >= '$fecha_ini_tipo' AND fecha <= '$fecha_fin_tipo' GROUP BY h.id_tipo_hallazgo order by cantidad DESC";
					
			$hallazgos_tipo = $this->select_all($sql);

			$sql1 = "SELECT COUNT(*) as cant_hallazgos_tipo
          FROM hallazgos h          
          WHERE fecha >= '$fecha_ini_tipo' AND fecha <= '$fecha_fin_tipo'";
          
      $cant_hallazgos_tipo = $this->select_all($sql1);


			$fecha_ini_tipo = convertirFechaBD_fecha($fecha_ini_tipo);
			$fecha_fin_tipo = convertirFechaBD_fecha($fecha_fin_tipo);
			$arrData = array('cant_hallazgos_tipo' => $cant_hallazgos_tipo[0], 'fecha_ini_tipo' => $fecha_ini_tipo, 'fecha_fin_tipo' => $fecha_fin_tipo, 'hallazgos_tipo' => $hallazgos_tipo, 'tipografico_tipo' => $tipografico_tipo);		
			
			return $arrData;
		}

		

		public function selectVentasMes(int $anio, int $mes){
		//	$rolid = $_SESSION['userData']['idrol'];
			$idUser = $_SESSION['userData']['id_usuario'];
			$where = "";
		//	if($rolid == RCLIENTES ){
		//		$where = " AND personaid = ".$idUser;
		//	}

			$totalVentasMes = 0;
			$arrVentaDias = array();
			$dias = cal_days_in_month(CAL_GREGORIAN,$mes, $anio);
			$n_dia = 1;
			for ($i=0; $i < $dias ; $i++) { 
				$date = date_create($anio."-".$mes."-".$n_dia);
				$fechaVenta = date_format($date,"Y-m-d");
				$sql = "SELECT DAY(fecha) AS dia, COUNT(idpedido) AS cantidad, SUM(monto) AS total 
						FROM pedido 
						WHERE DATE(fecha) = '$fechaVenta' AND status = 'Completo' ".$where;
				$ventaDia = $this->select($sql);
				$ventaDia['dia'] = $n_dia;
				$ventaDia['total'] = $ventaDia['total'] == "" ? 0 : $ventaDia['total'];
				$totalVentasMes += $ventaDia['total'];
				array_push($arrVentaDias, $ventaDia);
				$n_dia++;
			}
			$meses = Meses();
			$arrData = array('anio' => $anio, 'mes' => $meses[intval($mes-1)], 'total' => $totalVentasMes,'ventas' => $arrVentaDias );
			return $arrData;
		}
		public function selectVentasAnio(int $anio){
			$arrMVentas = array();
			$arrMeses = Meses();
			for ($i=1; $i <= 12; $i++) { 
				$arrData = array('anio'=>'','no_mes'=>'','mes'=>'','venta'=>'');
				$sql = "SELECT $anio AS anio, $i AS mes, SUM(monto) AS venta 
						FROM pedido 
						WHERE MONTH(fecha)= $i AND YEAR(fecha) = $anio AND status = 'Completo' 
						GROUP BY MONTH(fecha) ";
				$ventaMes = $this->select($sql);
				$arrData['mes'] = $arrMeses[$i-1];
				if(empty($ventaMes)){
					$arrData['anio'] = $anio;
					$arrData['no_mes'] = $i;
					$arrData['venta'] = 0;
				}else{
					$arrData['anio'] = $ventaMes['anio'];
					$arrData['no_mes'] = $ventaMes['mes'];
					$arrData['venta'] = $ventaMes['venta'];
				}
				array_push($arrMVentas, $arrData);
				# code...
			}
			$arrVentas = array('anio' => $anio, 'meses' => $arrMVentas);
			return $arrVentas;
		}
		public function productosTen(){
			$sql = "SELECT * FROM producto WHERE status = 1 ORDER BY idproducto DESC LIMIT 1,10 ";
			$request = $this->select_all($sql);
			return $request;
		}
	}
?>