<?php 

	class TiposHallazgo extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			session_regenerate_id(true);
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url_proyecto().'/login');
				die();
			}
			getPermisos(2);
		}

		public function TiposHallazgo()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url_proyecto().'/dashboard');
			}
			$data['page_tag'] = "Tipos Hallazgo";
			$data['page_title'] = "TIPOS HALLAZGO <small>Plataforma E-Hallazgos</small>";
			$data['page_name'] = "tiposhallazgo";
			$data['page_functions_js'] = "functions_tiposhallazgo.js";
			$this->views->getView($this,"tiposhallazgo",$data);
		}

		public function setTipoHallazgo()
		{
			if($_POST)
			{			
				if(empty($_POST['txtNombre']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}
				else
				{ 
					$intIdtipohallazgo = ucwords(strClean($_POST['idTipoHallazgo']));
					$strNombre = ucwords(strClean($_POST['txtNombre']));
					
					$request_tipohallazgo = "";		
					if($intIdtipohallazgo == 0)
					{
						$option = 1;						
						if($_SESSION['permisosMod']['w']){
							$request_tipohallazgo = $this->model->insertTipoHallazgo($strNombre);
						}
					}else{
						$option = 2;
						if($_SESSION['permisosMod']['u']){
							$request_tipohallazgo = $this->model->updateTipoHallazgo($intIdtipohallazgo,$strNombre);
						}

					}
				}

				if($request_tipohallazgo > 0 )
				{
						if($option == 1)
						{
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}
						else
						{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						}
				}
				else if($request_tipohallazgo == 'exist')
				{
						$arrResponse = array('status' => false, 'msg' => '¡Atención! el tipo de hallazgo ya existe, ingrese otra.');		
				}
				else
				{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getTiposHallazgo()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectTiposHallazgo();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					
					if($_SESSION['permisosMod']['u']){
						if(($_SESSION['idUser'] == 1 and $_SESSION['userData']['idrol'] == 1) ||
							$_SESSION['userData']['idrol'] == 1 ){
							$btnEdit = '<button class="btn btn-primary  btn-sm btnEditTipoHallazgo" onClick="fntEditTipoHallazgo(this,'.$arrData[$i]['id_tipo_hallazgo'].')" title="Editar tipo hallazgo"><i class="fas fa-pencil-alt"></i></button>';
						}else{
							$btnEdit = '<button class="btn btn-secondary btn-sm" disabled ><i class="fas fa-pencil-alt"></i></button>';
						}
					}
					if($_SESSION['permisosMod']['d']){
						if(($_SESSION['idUser'] == 1 and $_SESSION['userData']['idrol'] == 1) ||
							($_SESSION['userData']['idrol'] == 1 )  ){
							$parametro1 = $arrData[$i]['id_tipo_hallazgo'];
							$parametro2 = "'".$arrData[$i]['descripcion']."'";
							$btnDelete = '<button class="btn btn-danger btn-sm btnDelTipoHallazgo" 
							onClick="fntDelTipoHallazgo('.$parametro1.",".$parametro2.')" title="Eliminar tipo de hallazgo"><i class="far fa-trash-alt"></i></button>';
						}else{
							$btnDelete = '<button class="btn btn-secondary btn-sm" disabled ><i class="far fa-trash-alt"></i></button>';
						}
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getSelectTipos()
		{
			$htmlOptions = "";
			$arrData = $this->model->selectTiposHallazgo();			
			if(count($arrData) > 0 ){
				for ($i=0; $i < count($arrData); $i++) { 					
					$htmlOptions .= '<option value="'.$arrData[$i]['id_tipo_hallazgo'].'">'.$arrData[$i]['descripcion'].'</option>';					
				}
			}
			echo $htmlOptions;
			die();		
		}

		public function getTipoHallazgo($idtipohallazgo){
			if($_SESSION['permisosMod']['r']){
				$idtipohallazgo = intval($idtipohallazgo);
				if($idtipohallazgo > 0)
				{
					$arrData = $this->model->selectTipoHallazgo($idtipohallazgo);
					dep();
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delTipoHallazgo()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$idtipohallazgo = intval($_POST['idtipohallazgo']);

					$requestDelete = $this->model->deleteTipoHallazgo($idtipohallazgo);
					if($requestDelete)
					{
						$arrResponse = array('status' => true, 'msg' => 'Tipo de hallazgo eliminada exitosamente');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al eliminar el tipo de hallazgo');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}
	}
 ?>