<?php 

	class Dashboard extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			session_regenerate_id(true);
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url_proyecto().'/login');
				die();
			}
			getPermisos(1);
		}

		public function dashboard()
		{
			$data['page_id'] = 2;
			$data['page_tag'] = "Dashboard - E-Hallazgos";
			$data['page_title'] = "Dashboard - E-Hallazgos";
			$data['page_name'] = "dashboard";
			$data['page_functions_js'] = "functions_dashboard.js";
			$data['hallazgosabiertos'] = $this->model->cantHallazgosAbiertos();
			$data['hallazgoscerrados'] = $this->model->cantHallazgosCerrados();
			$data['hallazgosnulos'] = $this->model->cantHallazgosNulos();
			$data['hallazgostotal'] = $this->model->cantHallazgos();
			
			
			$data['lastHallazgos'] = $this->model->lastHallazgos();
			$data['productosTen'] = $this->model->productosTen();

			$anio = date('Y');
			$mes = date('m');
			$nFecha_fin = date("Y-m-d");
			$nFecha_ini = date('Y-m-01');  
			$tipografico = 'pie';
			$nFecha_fin_area = date("Y-m-d");
			$nFecha_ini_area = date('Y-m-01');  
			$tipografico_area = 'pie';

			$data['pagosMes'] = $this->model->selectPagosMes($anio,$mes);
			//dep($data['pagosMes']);exit;
			$data['ventasMDia'] = $this->model->selectVentasMes($anio,$mes);
			//dep($data['ventasMDia']);exit;
			$data['ventasAnio'] = $this->model->selectVentasAnio($anio);
			
			$data['graficocolaboradores'] = $this->model->selectHallazgosColaborador($nFecha_ini,$nFecha_fin,$tipografico);        
			$data['graficoarea'] = $this->model->selectHallazgosArea($nFecha_ini_area,$nFecha_fin_area,$tipografico_area);				

			//dep($data['ventasAnio']);exit;
			//if( $_SESSION['userData']['idrol'] == RCLIENTES ){
				//$this->views->getView($this,"dashboardCliente",$data);
		//	}else{
				$this->views->getView($this,"dashboard",$data);
		//	}
		}

	
	public function graficofuentes(){
      if($_POST){
        $grafica = "graficoporfuente";
        $nFecha_ini = convertirFecha_fechabd($_POST['fecha_ini']).'0000';
        $nFecha_fin = convertirFecha_fechabd($_POST['fecha_fin']).'2359';
        $tipografico =$_POST['tipografico'];

        $hallazgos = $this->model->selectHallazgosFuente($nFecha_ini,$nFecha_fin,$tipografico);        

        $script = getFile("Template/Modals/graficas_fuentes",$hallazgos);
        echo $script;
        die();
      }
    }
		public function graficoambitos(){
      if($_POST){
        $grafica = "graficoporambito";
        $nFecha_ini = convertirFecha_fechabd($_POST['fecha_ini']).'0000';
        $nFecha_fin = convertirFecha_fechabd($_POST['fecha_fin']).'2359';
        $tipografico =$_POST['tipografico'];

        $hallazgos = $this->model->selectHallazgosAmbito($nFecha_ini,$nFecha_fin,$tipografico);        

        $script = getFile("Template/Modals/graficas_ambitos",$hallazgos);
        echo $script;
        die();
      }
    }

		public function graficocolaboradores(){
      if($_POST){
        $grafica = "graficoporcolaborador";
        $nFecha_ini = convertirFecha_fechabd($_POST['fecha_ini']).'0000';
        $nFecha_fin = convertirFecha_fechabd($_POST['fecha_fin']).'2359';
        $tipografico =$_POST['tipografico'];

        $hallazgos = $this->model->selectHallazgosColaborador($nFecha_ini,$nFecha_fin,$tipografico);        

        $script = getFile("Template/Modals/graficas",$hallazgos);
        echo $script;
        die();
      }
    }

		public function graficoarea(){
			if($_POST){
				$grafica_area = "graficoporarea";
				$nFecha_ini_area = convertirFecha_fechabd($_POST['fecha_ini_area']).'0000';
				$nFecha_fin_area = convertirFecha_fechabd($_POST['fecha_fin_area']).'2359';
				$tipografico_area =$_POST['tipografico_area'];

				$hallazgos_area = $this->model->selectHallazgosArea($nFecha_ini_area,$nFecha_fin_area,$tipografico_area);				

				$script_area = getFile("Template/Modals/graficas_areas",$hallazgos_area);
				echo $script_area;
				die();
			}
		}
		
			public function graficoatipo(){
			if($_POST){
				$grafica_area = "graficoportipo";
				$nFecha_ini_tipo = convertirFecha_fechabd($_POST['fecha_ini_tipo']).'0000';
				$nFecha_fin_tipo = convertirFecha_fechabd($_POST['fecha_fin_tipo']).'2359';
				$tipografico_tipo =$_POST['tipografico_tipo'];

				$hallazgos_tipo = $this->model->selectHallazgosTipo($nFecha_ini_tipo,$nFecha_fin_tipo,$tipografico_tipo);				

				$script_tipo = getFile("Template/Modals/graficas_tipos",$hallazgos_tipo);
				echo $script_tipo;
				die();
			}
		}
		public function ventasMes(){
			if($_POST){
				$grafica = "ventasMes";
				$nFecha = str_replace(" ","",$_POST['fecha']);
				$arrFecha = explode('-',$nFecha);
				$mes = $arrFecha[0];
				$anio = $arrFecha[1];
				$pagos = $this->model->selectVentasMes($anio,$mes);
				$script = getFile("Template/Modals/graficas",$pagos);
				echo $script;
				die();
			}
		}
		public function ventasAnio(){
			if($_POST){
				$grafica = "ventasAnio";
				$anio = intval($_POST['anio']);
				$pagos = $this->model->selectVentasAnio($anio);
				$script = getFile("Template/Modals/graficas",$pagos);
				echo $script;
				die();
			}
		}

	}
 ?>