<?php 

	class Colaboradores extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			session_regenerate_id(true);
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url_proyecto().'/login');
				die();
			}
			getPermisos(2);
		}

		public function Colaboradores()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url_proyecto().'/dashboard');
			}
			$data['page_tag'] = "Colaboradores";
			$data['page_title'] = "COLABORADORES <small>E-Hallazgos</small>";
			$data['page_name'] = "colaboradores";
			$data['page_functions_js'] = "functions_colaboradores.js";
			$this->views->getView($this,"colaboradores",$data);
		}

		public function setColaborador(){
			if($_POST){			
				if(empty($_POST['txtNombre']) || empty($_POST['txtApellido']) || empty($_POST['txtTelefono']) || empty($_POST['txtEmail']) || empty($_POST['listCargoid']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}else{ 
					$idColaborador = intval($_POST['idColaborador']);					
					$strNombre = ucwords(strClean($_POST['txtNombre']));
					$strApellido = ucwords(strClean($_POST['txtApellido']));
					$intTelefono = intval(strClean($_POST['txtTelefono']));
					$strEmail = strtolower(strClean($_POST['txtEmail']));
					$intIdCargo = intval(strClean($_POST['listCargoid']));					
					$request_colaborador = "";

					if($idColaborador == 0)
					{
						$option = 1;							
						if($_SESSION['permisosMod']['w']){
							$request_colaborador = $this->model->insertColaborador($strNombre, 
																				$strApellido, 
																				$intTelefono, 
																				$strEmail,								
																				$intIdCargo);							
						}
					}else{
						$option = 2;						
						if($_SESSION['permisosMod']['u']){
							$request_colaborador = $this->model->updateColaborador($idColaborador,									
																		$strNombre,
																		$strApellido, 
																		$intTelefono, 
																		$strEmail,											
																		$intIdCargo);
						}

					}

					if($request_colaborador > 0 )
					{
						if($option == 1){
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}else{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						}
					}else if($request_colaborador == 'exist'){
						$arrResponse = array('status' => false, 'msg' => '¡Atención! el Colaborador ya existe, ingrese otro.');		
					}else{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
					}
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getColaboradores()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectColaboradores();

				for ($i=0; $i < count($arrData); $i++) {
					
					$btnEdit = '';
					$btnDelete = '';
					
					if($_SESSION['permisosMod']['u']){
						if($_SESSION['userData']['idrol'] == 1){
							$btnEdit = '<button class="btn btn-primary  btn-sm btnEditColaborador" onClick="fntEditColaborador(this,'.$arrData[$i]['id_empleado'].')" title="Editar colaborador"><i class="fas fa-pencil-alt"></i></button>';
						}else{
							$btnEdit = '<button class="btn btn-secondary btn-sm" disabled ><i class="fas fa-pencil-alt"></i></button>';
						}
					}
					if($_SESSION['permisosMod']['d']){
						if($_SESSION['userData']['idrol'] == 1) 
						{
							$btnDelete = '<button class="btn btn-danger btn-sm btnDelColaborador" onClick="fntDelColaborador('.$arrData[$i]['id_empleado'].')" title="Eliminar colaborador"><i class="far fa-trash-alt"></i></button>';
						}else{
							$btnDelete = '<button class="btn btn-secondary btn-sm" disabled ><i class="far fa-trash-alt"></i></button>';
						}
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnEdit.' '.$btnDelete.'</div>';
				}

				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getSelectColaboradores()
		{
			$htmlOptions = "";
			$arrData = $this->model->selectColaboradores();			
			if(count($arrData) > 0 ){
				for ($i=0; $i < count($arrData); $i++) { 					
					$htmlOptions .= '<option value="'.$arrData[$i]['id_empleado'].'">'.$arrData[$i]['nombre']." " .$arrData[$i]['apellido'].'</option>';					
				}
			}
			echo $htmlOptions;
			die();		
		}

		public function getColaborador($idempleado){
			if($_SESSION['permisosMod']['r']){
				$idcolaborador = intval($idempleado);
				if($idcolaborador > 0)
				{
					$arrData = $this->model->selectColaborador($idcolaborador);
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delColaborador()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$intIdempleado = intval($_POST['idColaborador']);
					$requestDelete = $this->model->deleteColaborador($intIdempleado);
					if($requestDelete)
					{
						$arrResponse = array('status' => true, 'msg' => 'Se ha eliminado el colaborador');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al eliminar el colaborador.');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}		
	}
 ?>