<?php 

	class Cargos extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			session_regenerate_id(true);
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url_proyecto().'/login');
				die();
			}
			getPermisos(2);
		}

		public function Cargos()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url_proyecto().'/dashboard');
			}
			$data['page_tag'] = "Cargos";
			$data['page_title'] = "CARGOS <small>Plataforma E-Hallazgos</small>";
			$data['page_name'] = "cargos";
			$data['page_functions_js'] = "functions_cargos.js";
			$this->views->getView($this,"cargos",$data);
		}

		public function setCargo()
		{
			if($_POST)
			{			
				if(empty($_POST['txtNombre']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}
				else
				{ 
					$intIdcargo = ucwords(strClean($_POST['idCargo']));
					$strNombre = ucwords(strClean($_POST['txtNombre']));
					
					$request_cargo = "";		
					if($intIdcargo == 0)
					{
						$option = 1;						
						if($_SESSION['permisosMod']['w']){
							$request_cargo = $this->model->insertCargo($strNombre);
						}
					}else{
						$option = 2;
						if($_SESSION['permisosMod']['u']){
							$request_cargo = $this->model->updateCargo($intIdcargo,$strNombre);
						}

					}
				}

				if($request_cargo > 0 )
				{
						if($option == 1)
						{
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}
						else
						{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						}
				}
				else if($request_cargo == 'exist')
				{
						$arrResponse = array('status' => false, 'msg' => '¡Atención! el cargo ya existe, ingrese otra.');		
				}
				else
				{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getCargos()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectCargos();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					
					if($_SESSION['permisosMod']['u']){
						if(($_SESSION['idUser'] == 1 and $_SESSION['userData']['idrol'] == 1) ||
							$_SESSION['userData']['idrol'] == 1 ){
							$btnEdit = '<button class="btn btn-primary  btn-sm btnEditCargo" onClick="fntEditCargo(this,'.$arrData[$i]['id_cargo_empleado'].')" title="Editar cargo"><i class="fas fa-pencil-alt"></i></button>';
						}else{
							$btnEdit = '<button class="btn btn-secondary btn-sm" disabled ><i class="fas fa-pencil-alt"></i></button>';
						}
					}
					if($_SESSION['permisosMod']['d']){
						if(($_SESSION['idUser'] == 1 and $_SESSION['userData']['idrol'] == 1) ||
							($_SESSION['userData']['idrol'] == 1 )  ){
							$parametro1 = $arrData[$i]['id_cargo_empleado'];
							$parametro2 = "'".$arrData[$i]['nombre_cargo']."'";
							$btnDelete = '<button class="btn btn-danger btn-sm btnDelCargo" 
							onClick="fntDelCargo('.$parametro1.",".$parametro2.')" title="Eliminar cargo"><i class="far fa-trash-alt"></i></button>';
						}else{
							$btnDelete = '<button class="btn btn-secondary btn-sm" disabled ><i class="far fa-trash-alt"></i></button>';
						}
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getSelectCargos()
		{
			$htmlOptions = "";
			$arrData = $this->model->selectCargos();			
			if(count($arrData) > 0 ){
				for ($i=0; $i < count($arrData); $i++) { 					
					$htmlOptions .= '<option value="'.$arrData[$i]['id_cargo_empleado'].'">'.$arrData[$i]['nombre_cargo'].'</option>';					
				}
			}
			echo $htmlOptions;
			die();		
		}


		public function getCargo($idcargo){
			if($_SESSION['permisosMod']['r']){
				$idcargo = intval($idcargo);
				if($idcargo > 0)
				{
					$arrData = $this->model->selectCargo($idcargo);
					
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delCargo()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$idcargo = intval($_POST['idcargo']);

					$requestDelete = $this->model->deleteCargo($idcargo);
					if($requestDelete)
					{
						$arrResponse = array('status' => true, 'msg' => 'Cargo eliminado exitosamente');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al eliminar el cargo');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}
	}
 ?>