<?php 

	class Areas extends Controllers{
		public function __construct()
		{
			parent::__construct();
			session_start();
			session_regenerate_id(true);
			if(empty($_SESSION['login']))
			{
				header('Location: '.base_url_proyecto().'/login');
				die();
			}
			getPermisos(2);
		}

		public function Areas()
		{
			if(empty($_SESSION['permisosMod']['r'])){
				header("Location:".base_url_proyecto().'/dashboard');
			}
			$data['page_tag'] = "Áreas";
			$data['page_title'] = "ÁREAS <small>Plataforma E-Hallazgos</small>";
			$data['page_name'] = "areas";
			$data['page_functions_js'] = "functions_areas.js";
			$this->views->getView($this,"areas",$data);
		}

		public function setArea()
		{
			if($_POST)
			{							
				if(empty($_POST['txtNombre']) || empty($_POST['txtSupervisor']) || empty($_POST['txtEmailSupervisor']))
				{
					$arrResponse = array("status" => false, "msg" => 'Datos incorrectos.');
				}
				else
				{ 
					$intIdarea = ucwords(strClean($_POST['idArea']));
					$strNombre = ucwords(strClean($_POST['txtNombre']));
					$strSupervisor = ucwords(strClean($_POST['txtSupervisor']));
					$strEmailSupervidor = (strClean($_POST['txtEmailSupervisor']));

					$request_area = "";		
					if($intIdarea == 0)
					{
						$option = 1;						
						if($_SESSION['permisosMod']['w']){
							$request_area = $this->model->insertArea($strNombre,$strSupervisor,$strEmailSupervidor);
						}
					}else{
						$option = 2;
						if($_SESSION['permisosMod']['u']){
							$request_area = $this->model->updateArea($intIdarea,$strNombre,$strSupervisor,$strEmailSupervidor);
						}

					}
				}

				if($request_area > 0 )
				{
						if($option == 1)
						{
							$arrResponse = array('status' => true, 'msg' => 'Datos guardados correctamente.');
						}
						else
						{
							$arrResponse = array('status' => true, 'msg' => 'Datos Actualizados correctamente.');
						}
				}
				else if($request_area == 'exist')
				{
						$arrResponse = array('status' => false, 'msg' => '¡Atención! el Área ya existe, ingrese otra.');		
				}
				else
				{
						$arrResponse = array("status" => false, "msg" => 'No es posible almacenar los datos.');
				}
				echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getAreas()
		{
			if($_SESSION['permisosMod']['r']){
				$arrData = $this->model->selectAreas();
				for ($i=0; $i < count($arrData); $i++) {
					$btnView = '';
					$btnEdit = '';
					$btnDelete = '';

					
					if($_SESSION['permisosMod']['u']){
						if(($_SESSION['idUser'] == 1 and $_SESSION['userData']['idrol'] == 1) ||
							$_SESSION['userData']['idrol'] == 1 ){
							$btnEdit = '<button class="btn btn-primary  btn-sm btnEditArea" onClick="fntEditArea(this,'.$arrData[$i]['id_area'].')" title="Editar área"><i class="fas fa-pencil-alt"></i></button>';
						}else{
							$btnEdit = '<button class="btn btn-secondary btn-sm" disabled ><i class="fas fa-pencil-alt"></i></button>';
						}
					}
					if($_SESSION['permisosMod']['d']){
						if(($_SESSION['idUser'] == 1 and $_SESSION['userData']['idrol'] == 1) ||
							($_SESSION['userData']['idrol'] == 1 )  ){
							$parametro1 = $arrData[$i]['id_area'];
							$parametro2 = "'".$arrData[$i]['nombre']."'";
							$btnDelete = '<button class="btn btn-danger btn-sm btnDelArea" 
							onClick="fntDelArea('.$parametro1.",".$parametro2.')" title="Eliminar área"><i class="far fa-trash-alt"></i></button>';
						}else{
							$btnDelete = '<button class="btn btn-secondary btn-sm" disabled ><i class="far fa-trash-alt"></i></button>';
						}
					}
					$arrData[$i]['options'] = '<div class="text-center">'.$btnView.' '.$btnEdit.' '.$btnDelete.'</div>';
				}
				echo json_encode($arrData,JSON_UNESCAPED_UNICODE);
			}
			die();
		}

		public function getSelectAreas()
		{
			$htmlOptions = "";
			$arrData = $this->model->selectAreas();		
			
			if(count($arrData) > 0 ){
				for ($i=0; $i < count($arrData); $i++) { 					
					$htmlOptions .= '<option value="'.$arrData[$i]['id_area'].'">'.$arrData[$i]['nombre'].'</option>';					
				}
			}
			echo $htmlOptions;
			die();		
		}


		public function getArea($idarea){
			if($_SESSION['permisosMod']['r']){
				$idarea = intval($idarea);
				if($idarea > 0)
				{
					$arrData = $this->model->selectArea($idarea);
					
					if(empty($arrData))
					{
						$arrResponse = array('status' => false, 'msg' => 'Datos no encontrados.');
					}else{
						$arrResponse = array('status' => true, 'data' => $arrData);
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}

		public function delArea()
		{
			if($_POST){
				if($_SESSION['permisosMod']['d']){
					$idarea = intval($_POST['idArea']);

					$requestDelete = $this->model->deleteArea($idarea);
					if($requestDelete)
					{
						$arrResponse = array('status' => true, 'msg' => 'Área eliminada exitosamente');
					}else{
						$arrResponse = array('status' => false, 'msg' => 'Error al eliminar el área');
					}
					echo json_encode($arrResponse,JSON_UNESCAPED_UNICODE);
				}
			}
			die();
		}
	}
 ?>