let tableHallazgos;
let rowTable = "";
$(document).on('focusin', function(e) {
    if ($(e.target).closest(".tox-dialog").length) {
        e.stopImmediatePropagation();
    }
});

tableHallazgos = $('#tableHallazgos').dataTable( {
    "aProcessing":true,
    "aServerSide":true,
    "language": {
       "decimal": "",
       "emptyTable": "No hay información",
       "info": "Mostrando _START_ a _END_ de _TOTAL_ Registros",
       "infoEmpty": "Mostrando 0 to 0 of 0 Registros",
       "infoFiltered": "(Filtrado de _MAX_ total registros)",
       "infoPostFix": "",
       "thousands": ",",
       "lengthMenu": "Mostrar _MENU_ Registros",
       "loadingRecords": "Cargando...",
       "processing": "Procesando...",
       "search": "Buscar:",
       "zeroRecords": "Sin resultados encontrados",
       "paginate": {
        "first": "Primero",
        "last": "Último",
        "next": "Siguiente",
        "previous": "Anterior"
    }
},
"ajax":{
    "url": " "+base_url+"/Hallazgos/getHallazgos",
    "dataSrc":""
},
"columns":[
    {"data":"id_hallazgo"},
    {"data":"nombretipohallazgo"},
    {"data":"fecha"},
    {"data":"lugarhallazgo"},
    {"data":"ambitohallazgo"},
    {"data":"fuentehallazgo"},
    {"data":"descripcion"},
    {"data":"nombrecompletoreporta"},
    {"data":"nombredigita"},
    {"data":"id_estado_hallazgo"},
    {"data":"fecha_cierre"},
    {"data":"options"}
    ],
"columnDefs": [
    { 'className': "textcenter", "targets": [ 0 ] },
    { 'className': "textcenter", "targets": [ 3 ] },
    { 'className': "textleft", "targets": [ 4 ] },
    { 'className': "textcenter", "targets": [ 5 ] }
    ],       
'dom': 'lBfrtip',
'buttons': [
{
    "extend": "copyHtml5",
    "text": "<i class='far fa-copy'></i> Copiar",
    "titleAttr":"Copiar",
    "className": "btn btn-secondary",
    "exportOptions": { 
        "columns": [ 0, 1, 2, 3, 4, 5] 
    }
},{
    "extend": "excelHtml5",
    "text": "<i class='fas fa-file-excel'></i> Excel",
    "titleAttr":"Esportar a Excel",
    "className": "btn btn-success",
    "exportOptions": { 
        "columns": [ 0, 1, 2, 3, 4, 5] 
    }
},{
    "extend": "pdfHtml5",
    "text": "<i class='fas fa-file-pdf'></i> PDF",
    "titleAttr":"Esportar a PDF",
    "className": "btn btn-danger",
    "exportOptions": { 
        "columns": [ 0, 1, 2, 3, 4, 5] 
    }
},{
    "extend": "csvHtml5",
    "text": "<i class='fas fa-file-csv'></i> CSV",
    "titleAttr":"Esportar a CSV",
    "className": "btn btn-info",
    "exportOptions": { 
        "columns": [ 0, 1, 2, 3, 4, 5] 
    }
}
],
"resonsieve":"true",
"bDestroy": true,
"iDisplayLength": 10,
"order":[[0,"desc"]]  
});
window.addEventListener('load', function() {
    if(document.querySelector("#formHallazgo")){
        let formHallazgo = document.querySelector("#formHallazgo");
        formHallazgo.onsubmit = function(e) {
            e.preventDefault();
            let intIdHallazgo = document.querySelector('#idHallazgo').value;
            let intLugarHallazgo = document.querySelector('#listLugarHallazgo').value;
            let intAreaHallazgo = document.querySelector('#listAreaHallazgo').value;
            let intColaboradorHallazgo = document.querySelector('#listColaboradorHallazgo').value;
            let strSupervisorArea = document.querySelector('#txtSupervisor').value;
            let intFuenteHallazgo = document.querySelector('#listFuenteHallazgo').value;
            let intAmbitoHallazgo = document.querySelector('#listAmbitoHallazgo').value;
            let intTipoHallazgo = document.querySelector('#listTipoHallazgo').value;
            let strDescripcionHallazgo = document.querySelector('#txtDescripcionHallazgo').value;
            let strAccionInmediataHallazgo = document.querySelector('#txtAccionInmediataHallazgo').value;
            let strCausaRaizHallazgo = document.querySelector('#txtCausaRaizHallazgo').value;
            let strComentarioHallazgo = document.querySelector('#txtComentarioHallazgo').value;
            let intResponsableAnalisisCausal = document.querySelector('#txtResponsableAnalisisCausal').value;
            if (intIdHallazgo != 0)
            {
                let intEvaluacionEficacia = document.querySelector('#EvaluacionEficacia').value;
            }

            if( intLugarHallazgo == 0 || intAreaHallazgo == 0 || intColaboradorHallazgo == 0 || strSupervisorArea == "" || intFuenteHallazgo == 0  || intAmbitoHallazgo == 0 
                || intTipoHallazgo == 0 || strDescripcionHallazgo == "" || strAccionInmediataHallazgo == "" || strCausaRaizHallazgo == "")
            {
                swal("Atención", "Todos los campos son obligatorios." , "error");
                return false;
            }
            
            divLoading.style.display = "flex";
            
            let request = (window.XMLHttpRequest) ? 
            new XMLHttpRequest() : 
            new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Hallazgos/setHallazgo'; 
            let formData = new FormData(formHallazgo);
            request.open("POST",ajaxUrl,true);
            request.send(formData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){

                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        document.querySelector("#idHallazgo").value = objData.idhallazgo;
                        document.querySelector("#containerGallery").classList.remove("notblock");

                        if(rowTable == ""){
                            tableHallazgos.api().ajax.reload();
                        }else{

                            //rowTable.cells[1].textContent = intIdHallazgo;
                            //rowTable.cells[2].textContent = str;
                            //rowTable.cells[3].textContent = intStock;
                            //rowTable.cells[4].textContent = smony+strPrecio;
                            //rowTable.cells[5].innerHTML =  htmlStatus;
                            rowTable = ""; 
                        }
                        $('#modalFormHallazgos').modal("hide");                        
                        formHallazgo.reset();
                        swal("", objData.msg ,"success");

                    }else{
                        swal("Error", objData.msg , "error");
                    }
                }
                divLoading.style.display = "none";
                return false;
            }
        }
    }

    if(document.querySelector(".btnAddImage")){
     let btnAddImage =  document.querySelector(".btnAddImage");
     btnAddImage.onclick = function(e){
        let key = Date.now();
        let newElement = document.createElement("div");
        newElement.id= "div"+key;
        newElement.innerHTML = `
        <div class="prevImage"></div>
        <input type="file" name="foto" id="img${key}" class="inputUploadfile">
        <label for="img${key}" class="btnUploadfile"><i class="fas fa-upload "></i></label>
        <button class="btnDeleteImage notblock" type="button" onclick="fntDelItem('#div${key}')"><i class="fas fa-trash-alt"></i></button>`;
        document.querySelector("#containerImages").appendChild(newElement);
        document.querySelector("#div"+key+" .btnUploadfile").click();        
        fntInputFile();
    }
}

fntInputFile();    

}, false);




function fntInputFile(){
    let inputUploadfile = document.querySelectorAll(".inputUploadfile");    
    inputUploadfile.forEach(function(inputUploadfile) {
        inputUploadfile.addEventListener('change', function(){
            let idHallazgo = document.querySelector("#idHallazgo").value;

            let parentId = this.parentNode.getAttribute("id");
            let idFile = this.getAttribute("id");            
            let uploadFoto = document.querySelector("#"+idFile).value;
            let fileimg = document.querySelector("#"+idFile).files;
            let prevImg = document.querySelector("#"+parentId+" .prevImage");
            let nav = window.URL || window.webkitURL;
            if(uploadFoto !=''){
                let type = fileimg[0].type;
                let name = fileimg[0].name;
                if(type != 'image/jpeg' && type != 'image/jpg' && type != 'image/png'){
                    prevImg.innerHTML = "Archivo no válido";
                    uploadFoto.value = "";
                    return false;
                }else{
                    let objeto_url = nav.createObjectURL(this.files[0]);
                    prevImg.innerHTML = `<img class="loading" src="${base_url}/Assets/images/loading.svg" >`;

                    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
                    let ajaxUrl = base_url+'/Hallazgos/setImage'; 
                    let formData = new FormData();
                    formData.append('idhallazgo',idHallazgo);
                    formData.append("foto", this.files[0]);
                    request.open("POST",ajaxUrl,true);
                    request.send(formData);
                    request.onreadystatechange = function(){
                        if(request.readyState != 4) return;
                        if(request.status == 200){
                            let objData = JSON.parse(request.responseText);
                            if(objData.status){
                                prevImg.innerHTML = `<img src="${objeto_url}">`;
                                document.querySelector("#"+parentId+" .btnDeleteImage").setAttribute("imgname",objData.imgname);
                                document.querySelector("#"+parentId+" .btnUploadfile").classList.add("notblock");
                                document.querySelector("#"+parentId+" .btnDeleteImage").classList.remove("notblock");
                            }else{
                                swal("Error", objData.msg , "error");
                            }
                        }
                    }

                }
            }

        });
    });
}

function fntDelItem(element){
    let nameImg = document.querySelector(element+' .btnDeleteImage').getAttribute("imgname");
    let idHallazgo = document.querySelector("#idHallazgo").value;
    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Hallazgos/delFile'; 

    let formData = new FormData();
    formData.append('idhallazgo',idHallazgo);
    formData.append("file",nameImg);
    request.open("POST",ajaxUrl,true);
    request.send(formData);
    request.onreadystatechange = function(){
        if(request.readyState != 4) return;
        if(request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let itemRemove = document.querySelector(element);
                itemRemove.parentNode.removeChild(itemRemove);
            }else{
                swal("", objData.msg , "error");
            }
        }
    }
}

function fntViewInfo(idHallazgo){
    let request = (window.XMLHttpRequest) ? 
    new XMLHttpRequest() : 
    new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Hallazgos/getHallazgo/'+idHallazgo;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200){
            let objData = JSON.parse(request.responseText);
            if(objData.status)
            {
                let htmlImage = "";
                let objHallazgo = objData.data;
//                let estadoHallazgo = objHallazgo.id_estado_hallazgo == 1 ? 
  //              '<span class="badge badge-success">Abierto</span>' : 
    //            '<span class="badge badge-danger">Cerrado</span>' 
      //          '<span class="badge badge-danger">Nulo</span>';

                document.querySelector("#celDescripcion").innerHTML = objHallazgo.descripcion;
                document.querySelector("#celNombreTipoHallazgo").innerHTML = objHallazgo.nombretipohallazgo;
                document.querySelector("#celLugarHallazgo").innerHTML = objHallazgo.lugarhallazgo;
                document.querySelector("#celAmbitoHallazgo").innerHTML = objHallazgo.ambitohallazgo;
                document.querySelector("#celFuenteHallazgo").innerHTML = objHallazgo.fuentehallazgo;
                document.querySelector("#celStatus").innerHTML = estadoHallazgo;
                document.querySelector("#celNombreReporta").innerHTML = objHallazgo.nombrereporta;
                document.querySelector("#celApellidoReporta").innerHTML = objHallazgo.apellidoreporta;
                document.querySelector("#celNombreDigita").innerHTML = objHallazgo.nombredigita;
                document.querySelector("#celApellidoDigita").innerHTML = objHallazgo.apellidodigita;


                if(objHallazgo.images.length > 0){
                    let objHallazgos = objHallazgo.images;
                    for (let p = 0; p < objHallazgos.length; p++) {
                        htmlImage +=`<img src="${objHallazgos[p].url_image}"></img>`;
                    }
                }
                document.querySelector("#celFotos").innerHTML = htmlImage;
                $('#modalViewHallazgo').modal('show');

            }else{
                swal("Error", objData.msg , "error");
            }
        }
    } 
}

function fntEditInfo(element,idHallazgo)
{
    rowTable = element.parentNode.parentNode.parentNode;
    document.querySelector('#titleModal').innerHTML ="Actualizar Hallazgo";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Actualizar";
    let request = (window.XMLHttpRequest) ? 
    new XMLHttpRequest() : 
    new ActiveXObject('Microsoft.XMLHTTP');

    let ajaxUrl = base_url+'/Hallazgos/getHallazgo/'+idHallazgo;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function()
    {        
        if(request.readyState == 4 && request.status == 200)
        {
            let objData = JSON.parse(request.responseText);
            
            let htmlImage = "";
            let objHallazgo = objData.data;
            id_hallazgo = objHallazgo.id_hallazgo;
            estado = objHallazgo.id_estado_hallazgo;
            
            document.querySelector('#idHallazgo').value = objHallazgo.id_hallazgo;
            document.querySelector('#FolioHallazgo').innerHTML = objHallazgo.id_hallazgo;
            document.querySelector('#listLugarHallazgo').value = objHallazgo.id_obra;
            document.querySelector('#listAreaHallazgo').value =  objHallazgo.area;
            document.querySelector('#listColaboradorHallazgo').value = objHallazgo.empleado;
            document.querySelector('#listFuenteHallazgo').value = objHallazgo.id_fuente_no_conformidad;            
            document.querySelector('#listAmbitoHallazgo').value =  objHallazgo.id_ambito_hallazgo;
            document.querySelector('#listTipoHallazgo').value =  objHallazgo.id_tipo_hallazgo;            
            document.querySelector('#txtDescripcionHallazgo').innerHTML = objHallazgo.descripcion;
            document.querySelector('#txtAccionInmediataHallazgo').innerHTML = objHallazgo.accion_inmediata; 
            document.querySelector('#txtCausaRaizHallazgo').innerHTML = objHallazgo.analisis; 
            document.querySelector('#txtComentarioHallazgo').innerHTML = objHallazgo.comentario; 
            document.querySelector('#txtResponsableAnalisisCausal').value= objHallazgo.id_responsable_analisis_causal; 
            document.querySelector('#listEstadoHallazgo').value= objHallazgo.id_estado_hallazgo; 
            flash = objHallazgo.flash; 
            
            if (id_hallazgo != 0 && estado == 1) // Cerrado
            {                                    
                
                if (objHallazgo.evaluacion_eficacia == 1)
                {
                    document.querySelector("#containerevaluacion").innerHTML = "<label for=textarea>Seguimiento del cierre</label><table><tr><td class=td_datos_listado width=10% align=center><input type=radio id=EvaluacionEficacia name=EvaluacionEficacia value=1 checked><font color=blue>SÍ <br>El análisis causal y la efectividad de las acciones tomadas son satisfactorias</font></td><td class=td_datos_listado width=10% align=center><input type=radio id=EvaluacionEficacia  name=EvaluacionEficacia value=0> NO <br>Re-evaluar el análisis causal y las acciones definidas, para ello debe generar un nuevo reporte</td></tr></table>";
                }
                else
                {
                        document.querySelector("#containerevaluacion").innerHTML = "<label for=textarea>Seguimiento del cierre</label><table><tr><td class=td_datos_listado width=10% align=center><input type=radio id=EvaluacionEficacia name=EvaluacionEficacia value=1 <font color=blue>SÍ <br>El análisis causal y la efectividad de las acciones tomadas son satisfactorias</font></td><td class=td_datos_listado width=10% align=center><input type=radio id=EvaluacionEficacia  name=EvaluacionEficacia value=0 checked> NO <br>Re-evaluar el análisis causal y las acciones definidas, para ello debe generar un nuevo reporte</td></tr></table>";
                }
            }
            else
            {
                document.querySelector("#containerevaluacion").innerHTML = ""
            }

            if (flash == 1)
                document.querySelector("#div_flash").innerHTML = "<input type=checkbox id=chkFlash checked disabled name=chkFlash value=1> Notificar a toda la organizaci&oacuten";
            else
                document.querySelector("#div_flash").innerHTML = "<input type=checkbox id=chkFlash name=chkFlash disabled value=1> Notificar a toda la organizaci&oacuten";

            $('#listLugarHallazgo').selectpicker('render');
            $('#listAreaHallazgo').selectpicker('render');
            $('#llistColaboradorHallazgo').selectpicker('render');
            $('#listFuenteHallazgo').selectpicker('render');
            $('#listAmbitoHallazgo').selectpicker('render');
            $('#listTipoHallazgo').selectpicker('render');

            if(objHallazgo.images.length > 0)
            {
                let objHallazgos = objHallazgo.images;
                for (let p = 0; p < objHallazgos.length; p++) 
                {
                    let key = Date.now()+p;
                    htmlImage +=`<div id="div${key}">
                    <div class="prevImage">
                    <img src="${objHallazgos[p].url_image}"></img>
                    </div>
                    <button type="button" class="btnDeleteImage" onclick="fntDelItem('#div${key}')" imgname="${objHallazgos[p].img}">
                    <i class="fas fa-trash-alt"></i></button></div>`;
                }
            }



            document.querySelector("#containerImages").innerHTML = htmlImage;                 
            document.querySelector("#containerGallery").classList.remove("notblock");                 
            $('#modalFormHallazgos').modal('show');
        }
    }
}

function fntDelInfo(idHallazgo){
    swal({
        title: "Eliminar Hallazgo",
        text: "¿Realmente quiere eliminar el hallazgo?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {

        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Hallazgos/delHallazgo';
            let strData = "idHallazgo="+idHallazgo;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableHallazgos.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });

}


function fntLugares()
{
    if(document.querySelector('#listLugarHallazgo'))
    {
        let ajaxUrl = base_url+'/Lugares/getSelectLugares';
        let request = (window.XMLHttpRequest) ? 
        new XMLHttpRequest() : 
        new ActiveXObject('Microsoft.XMLHTTP');
        request.open("GET",ajaxUrl,true);
        request.send();
        request.onreadystatechange = function()
        {
            if(request.readyState == 4 && request.status == 200)
            {
                document.querySelector('#listLugarHallazgo').innerHTML = request.responseText;
                $('#listLugarHallazgo').selectpicker('render');
            }
        }
    }
}

function fntAreas()
{
    if(document.querySelector('#listAreaHallazgo'))
    {
        let ajaxUrl = base_url+'/Areas/getSelectAreas';
        let request = (window.XMLHttpRequest) ? 
        new XMLHttpRequest() : 
        new ActiveXObject('Microsoft.XMLHTTP');
        request.open("GET",ajaxUrl,true);
        request.send();
        request.onreadystatechange = function()
        {
            if(request.readyState == 4 && request.status == 200)
            {
                document.querySelector('#listAreaHallazgo').innerHTML = request.responseText;
                $('#listAreaHallazgo').selectpicker('render');
            }
        }
    }
}

function fntColaboradores()
{
    if(document.querySelector('#listColaboradorHallazgo'))
    {
        let ajaxUrl = base_url+'/Colaboradores/getSelectColaboradores';
        let request = (window.XMLHttpRequest) ? 
        new XMLHttpRequest() : 
        new ActiveXObject('Microsoft.XMLHTTP');
        request.open("GET",ajaxUrl,true);
        request.send();
        request.onreadystatechange = function()
        {
            if(request.readyState == 4 && request.status == 200)
            {
                document.querySelector('#listColaboradorHallazgo').innerHTML = request.responseText;
                $('#listColaboradorHallazgo').selectpicker('render');
            }
        }
    }
}


function fntFuentes()
{
    if(document.querySelector('#listFuenteHallazgo'))
    {
        let ajaxUrl = base_url+'/FuentesHallazgo/getSelectFuentesHallazgo';
        let request = (window.XMLHttpRequest) ? 
        new XMLHttpRequest() : 
        new ActiveXObject('Microsoft.XMLHTTP');
        request.open("GET",ajaxUrl,true);
        request.send();
        request.onreadystatechange = function()
        {
            if(request.readyState == 4 && request.status == 200)
            {
                document.querySelector('#listFuenteHallazgo').innerHTML = request.responseText;
                $('#listFuenteHallazgo').selectpicker('render');
            }
        }
    }
}

function fntAmbitos()
{
    if(document.querySelector('#listAmbitoHallazgo'))
    {
        let ajaxUrl = base_url+'/Ambitos/getSelectAmbitos';
        let request = (window.XMLHttpRequest) ? 
        new XMLHttpRequest() : 
        new ActiveXObject('Microsoft.XMLHTTP');
        request.open("GET",ajaxUrl,true);
        request.send();
        request.onreadystatechange = function()
        {
            if(request.readyState == 4 && request.status == 200)
            {
                document.querySelector('#listAmbitoHallazgo').innerHTML = request.responseText;
                $('#listAmbitoHallazgo').selectpicker('render');
            }
        }
    }
}


function fntTipos()
{
    if(document.querySelector('#listTipoHallazgo'))
    {
        let ajaxUrl = base_url+'/TiposHallazgo/getSelectTipos';
        let request = (window.XMLHttpRequest) ? 
        new XMLHttpRequest() : 
        new ActiveXObject('Microsoft.XMLHTTP');
        request.open("GET",ajaxUrl,true);
        request.send();
        request.onreadystatechange = function()
        {
            if(request.readyState == 4 && request.status == 200)
            {
                document.querySelector('#listTipoHallazgo').innerHTML = request.responseText;
                $('#listTipoHallazgo').selectpicker('render');
            }
        }
    }
}

function fntUsuarios()
{
    if(document.querySelector('#listUsuario'))
    {
        let ajaxUrl = base_url+'/Usuarios/getSelectUsuarios';
        let request = (window.XMLHttpRequest) ? 
        new XMLHttpRequest() : 
        new ActiveXObject('Microsoft.XMLHTTP');
        request.open("GET",ajaxUrl,true);
        request.send();
        request.onreadystatechange = function()
        {
            if(request.readyState == 4 && request.status == 200)
            {
                document.querySelector('#listUsuario').innerHTML = request.responseText;
                $('#listUsuario').selectpicker('render');
            }
        }
    }
}

function cargar_supervisor(idarea)
{

    let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
    let ajaxUrl = base_url+'/Areas/getArea/'+idarea;
    request.open("GET",ajaxUrl,true);
    request.send();
    request.onreadystatechange = function(){
        if(request.readyState == 4 && request.status == 200)
        {
            let objData = JSON.parse(request.responseText);
            
            document.querySelector("#txtSupervisor").innerHTML = "Supervisor del área: " + objData.data.supervisor;                     
            document.querySelector("#txtSupervisorArea").value = objData.data.supervisor;                
            document.querySelector("#txtEmailSupervisor").innerHTML = "Email: "+objData.data.email_supervisor;                
        }   
        else
        {
            document.querySelector("#txtSupervisor").innerHTML = "";   
            document.querySelector("#txtSupervisorArea").value = "";   
            document.querySelector("#txtEmailSupervisor").innerHTML = "";                
        }

        //$('#modalFormAreas').modal('show');
    }
}


function openModal()
{

    rowTable = "";
    document.querySelector('#idHallazgo').value ="";
    document.querySelector('#titleModal').innerHTML ="Nuevo Hallazgo";
    document.querySelector('.modal-header').classList.replace("headerRegister", "headerUpdate");
    document.querySelector('#btnActionForm').classList.replace("btn-primary", "btn-info");
    document.querySelector('#btnText').innerHTML ="Guardar";
    document.querySelector("#formHallazgo").reset();
    document.querySelector("#div_flash").innerHTML = "<input type=checkbox id=chkFlash name=chkFlash value=1> Notificar a toda la organizaci&oacuten";
    document.querySelector("#containerImages").innerHTML = "";                 
    document.querySelector("#containerGallery").classList.remove("notblock");                 
    $('#modalFormHallazgos').modal('show');

}

function cambiar_estado_hallazgo(estado)
{
  swal({
        title: "Cerrar Hallazgo",
        text: "¿Realmente quiere eliminar el hallazgo?",
        type: "warning",
        showCancelButton: true,
        confirmButtonText: "Si, eliminar!",
        cancelButtonText: "No, cancelar!",
        closeOnConfirm: false,
        closeOnCancel: true
    }, function(isConfirm) {

        if (isConfirm) 
        {
            let request = (window.XMLHttpRequest) ? new XMLHttpRequest() : new ActiveXObject('Microsoft.XMLHTTP');
            let ajaxUrl = base_url+'/Hallazgos/setHallazgo';
            let strData = "idHallazgo="+idHallazgo;
            request.open("POST",ajaxUrl,true);
            request.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
            request.send(strData);
            request.onreadystatechange = function(){
                if(request.readyState == 4 && request.status == 200){
                    let objData = JSON.parse(request.responseText);
                    if(objData.status)
                    {
                        swal("Eliminar!", objData.msg , "success");
                        tableHallazgos.api().ajax.reload();
                    }else{
                        swal("Atención!", objData.msg , "error");
                    }
                }
            }
        }

    });
    
   
}

 

